/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.messaging.LookupService;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.services.MessagingService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

public class ArchiveService
implements Bootable {
    private String host = null;
    private int port = -1;
    private boolean enabled = false;
    private AbstractCommand get = null;
    private AbstractCommand put = null;
    private AbstractCommand del = null;
    private AbstractCommand next = null;
    private AbstractCommand list = null;
    private AbstractCommand getMeta = null;
    private AbstractCommand putMeta = null;

    public Class[] depends() {
        return new Class[]{MessagingService.class};
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        Logger.info((String)"checking jameica.messaging availability");
        if (Application.getPluginLoader().getPlugin("de.willuhn.jameica.messaging.Plugin") != null) {
            Logger.info((String)"local jameica.messaging available");
            this.enabled = true;
            return;
        }
        try {
            int colon;
            String uri = LookupService.lookup("tcp:de.willuhn.jameica.messaging.Plugin.connector.tcp");
            if (uri != null && (colon = uri.indexOf(58)) != -1) {
                this.host = uri.substring(0, colon);
                this.port = Integer.parseInt(uri.substring(colon + 1));
                Logger.info((String)("remote jameica.messaging available on " + this.host + ":" + this.port));
                this.enabled = true;
            }
        }
        catch (Exception e) {
            Logger.error((String)"unable to determine uri to archive service", (Throwable)e);
        }
        if (this.host == null || this.port == -1) {
            Logger.warn((String)"no archive server found");
            return;
        }
        this.get = new Get();
        this.put = new Put();
        this.del = new Del();
        this.next = new Next();
        this.list = new List();
        this.getMeta = new GetMeta();
        this.putMeta = new PutMeta();
        Application.getMessagingFactory().getMessagingQueue("jameica.messaging.get").registerMessageConsumer(this.get);
        Application.getMessagingFactory().getMessagingQueue("jameica.messaging.put").registerMessageConsumer(this.put);
        Application.getMessagingFactory().getMessagingQueue("jameica.messaging.del").registerMessageConsumer(this.del);
        Application.getMessagingFactory().getMessagingQueue("jameica.messaging.next").registerMessageConsumer(this.next);
        Application.getMessagingFactory().getMessagingQueue("jameica.messaging.list").registerMessageConsumer(this.list);
        Application.getMessagingFactory().getMessagingQueue("jameica.messaging.getmeta").registerMessageConsumer(this.getMeta);
        Application.getMessagingFactory().getMessagingQueue("jameica.messaging.putmeta").registerMessageConsumer(this.putMeta);
    }

    public void shutdown() {
        if (this.get != null) {
            Application.getMessagingFactory().getMessagingQueue("jameica.messaging.get").unRegisterMessageConsumer(this.get);
        }
        if (this.put != null) {
            Application.getMessagingFactory().getMessagingQueue("jameica.messaging.put").unRegisterMessageConsumer(this.put);
        }
        if (this.del != null) {
            Application.getMessagingFactory().getMessagingQueue("jameica.messaging.del").unRegisterMessageConsumer(this.del);
        }
        if (this.next != null) {
            Application.getMessagingFactory().getMessagingQueue("jameica.messaging.next").unRegisterMessageConsumer(this.next);
        }
        if (this.list != null) {
            Application.getMessagingFactory().getMessagingQueue("jameica.messaging.list").unRegisterMessageConsumer(this.list);
        }
        if (this.getMeta != null) {
            Application.getMessagingFactory().getMessagingQueue("jameica.messaging.getmeta").unRegisterMessageConsumer(this.getMeta);
        }
        if (this.putMeta != null) {
            Application.getMessagingFactory().getMessagingQueue("jameica.messaging.putmeta").unRegisterMessageConsumer(this.putMeta);
        }
    }

    private Socket createSocket() {
        if (this.host == null || this.port <= 0) {
            return null;
        }
        try {
            return new Socket(this.host, this.port);
        }
        catch (Exception e) {
            Logger.error((String)("unable to create socket to archive server, host: " + this.host + ", port: " + this.port), (Throwable)e);
            return null;
        }
    }

    private abstract class AbstractCommand
    implements MessageConsumer {
        private AbstractCommand() {
        }

        @Override
        public boolean autoRegister() {
            return false;
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{QueryMessage.class};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message message) throws Exception {
            Socket socket = ArchiveService.this.createSocket();
            if (socket == null) {
                Logger.debug((String)"skip remote message delivery, no archive server found");
                return;
            }
            QueryMessage msg = (QueryMessage)message;
            try {
                this.handle(msg, socket);
            }
            catch (Exception e) {
                Logger.error((String)"error while delivering message", (Throwable)e);
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception e) {
                        Logger.error((String)"error while closing socket", (Throwable)e);
                    }
                }
            }
        }

        abstract void handle(QueryMessage var1, Socket var2) throws Exception;
    }

    private class Get
    extends AbstractCommand {
        private Get() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handle(QueryMessage message, Socket socket) throws Exception {
            String uuid = message.getName();
            if (uuid == null || uuid.length() == 0) {
                throw new Exception("no uuid given");
            }
            BufferedOutputStream os = null;
            BufferedInputStream is = null;
            try {
                os = new BufferedOutputStream(socket.getOutputStream());
                ((OutputStream)os).write(("get " + uuid + "\r\n").getBytes());
                ((OutputStream)os).flush();
                socket.shutdownOutput();
                is = new BufferedInputStream(socket.getInputStream());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                long count = IOUtil.copy((InputStream)is, (OutputStream)bos);
                message.setData(bos.toByteArray());
                Logger.info((String)("got " + count + " bytes for message, uuid " + uuid));
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{is, os});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{is, os});
        }
    }

    private class Put
    extends AbstractCommand {
        private Put() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handle(QueryMessage message, Socket socket) throws Exception {
            Object o = message.getData();
            if (o == null) {
                throw new Exception("message contains no data");
            }
            String channel = message.getName();
            if (channel == null) {
                channel = "";
            }
            BufferedOutputStream os = null;
            BufferedInputStream is = null;
            try {
                byte[] data;
                os = new BufferedOutputStream(socket.getOutputStream());
                ((OutputStream)os).write(("put " + channel + "\r\n").getBytes());
                long length = 0L;
                if (o instanceof byte[]) {
                    data = (byte[])o;
                    length = data.length;
                    ((OutputStream)os).write(data);
                } else if (o instanceof InputStream) {
                    length = IOUtil.copy((InputStream)((InputStream)o), (OutputStream)os);
                } else {
                    data = o.toString().getBytes();
                    length = data.length;
                    ((OutputStream)os).write(data);
                }
                ((OutputStream)os).flush();
                socket.shutdownOutput();
                is = new BufferedInputStream(socket.getInputStream());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IOUtil.copy((InputStream)is, (OutputStream)bos);
                String uuid = bos.toString().trim();
                Logger.info((String)("sent " + length + " bytes to channel " + channel + ", generated uuid: " + uuid));
                message.setData(uuid);
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{is, os});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{is, os});
        }
    }

    private class Del
    extends AbstractCommand {
        private Del() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handle(QueryMessage message, Socket socket) throws Exception {
            String uuid = message.getName();
            if (uuid == null || uuid.length() == 0) {
                throw new Exception("no uuid given");
            }
            BufferedOutputStream os = null;
            try {
                os = new BufferedOutputStream(socket.getOutputStream());
                ((OutputStream)os).write(("delete " + uuid + "\r\n").getBytes());
                ((OutputStream)os).flush();
                socket.shutdownOutput();
                Logger.info((String)("deleted message, uuid " + uuid));
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{os});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{os});
        }
    }

    private class Next
    extends AbstractCommand {
        private Next() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handle(QueryMessage message, Socket socket) throws Exception {
            String channel = message.getName();
            if (channel == null) {
                channel = "";
            }
            BufferedOutputStream os = null;
            BufferedInputStream is = null;
            try {
                os = new BufferedOutputStream(socket.getOutputStream());
                ((OutputStream)os).write(("next " + channel + "\r\n").getBytes());
                ((OutputStream)os).flush();
                socket.shutdownOutput();
                is = new BufferedInputStream(socket.getInputStream());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                long count = IOUtil.copy((InputStream)is, (OutputStream)bos);
                message.setData(bos.toByteArray());
                Logger.info((String)("got " + count + " bytes for channel " + channel));
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{is, os});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{is, os});
        }
    }

    private class List
    extends AbstractCommand {
        private List() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handle(QueryMessage message, Socket socket) throws Exception {
            String channel = message.getName();
            if (channel == null) {
                channel = "";
            }
            BufferedOutputStream os = null;
            BufferedInputStream is = null;
            try {
                os = new BufferedOutputStream(socket.getOutputStream());
                ((OutputStream)os).write(("list " + channel + "\r\n").getBytes());
                ((OutputStream)os).flush();
                socket.shutdownOutput();
                is = new BufferedInputStream(socket.getInputStream());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IOUtil.copy((InputStream)is, (OutputStream)bos);
                LinkedList<String> uuids = new LinkedList<String>();
                String data = bos.toString();
                if (data != null && data.length() > 0) {
                    uuids.addAll(Arrays.asList(data.split(",")));
                    message.setData(uuids);
                }
                Logger.info((String)("got " + uuids.size() + " uuids for channel " + channel));
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{is, os});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{is, os});
        }
    }

    private class GetMeta
    extends AbstractCommand {
        private GetMeta() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handle(QueryMessage message, Socket socket) throws Exception {
            String uuid = message.getName();
            if (uuid == null || uuid.length() == 0) {
                throw new Exception("no uuid given");
            }
            BufferedOutputStream os = null;
            BufferedInputStream is = null;
            try {
                os = new BufferedOutputStream(socket.getOutputStream());
                ((OutputStream)os).write(("getmeta " + uuid + "\r\n").getBytes());
                ((OutputStream)os).flush();
                socket.shutdownOutput();
                is = new BufferedInputStream(socket.getInputStream());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IOUtil.copy((InputStream)is, (OutputStream)bos);
                Properties props = new Properties();
                props.load(new ByteArrayInputStream(bos.toByteArray()));
                message.setData(props);
                Logger.info((String)("got " + props.size() + " properties for message, uuid " + uuid));
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{is, os});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{is, os});
        }
    }

    private class PutMeta
    extends AbstractCommand {
        private PutMeta() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handle(QueryMessage message, Socket socket) throws Exception {
            Object data = message.getData();
            if (data == null || !(data instanceof Map)) {
                throw new Exception("message contains no map as data");
            }
            String uuid = message.getName();
            if (uuid == null || uuid.length() == 0) {
                throw new Exception("no uuid given");
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Properties props = new Properties();
            props.putAll((Map<?, ?>)((Map)data));
            props.store(bos, "");
            BufferedOutputStream os = null;
            try {
                os = new BufferedOutputStream(socket.getOutputStream());
                ((OutputStream)os).write(("putmeta " + uuid + "\r\n").getBytes());
                ((OutputStream)os).write(bos.toByteArray());
                ((OutputStream)os).flush();
                socket.shutdownOutput();
                Logger.info((String)("sent " + props.size() + " properties for message, uuid " + uuid));
            }
            catch (Throwable throwable) {
                IOUtil.close((Closeable[])new Closeable[]{os});
                throw throwable;
            }
            IOUtil.close((Closeable[])new Closeable[]{os});
        }
    }
}

